/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.ComponentModel;
using System.Drawing; // For ToolboxBitmap
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;

namespace Borland.Eco.Handles
{
	/// <summary>
	/// References an element.
	/// </summary>
	[ToolboxBitmap(typeof(ReferenceHandle), "Borland.Eco.Handles.ReferenceHandle.bmp")]
	[ToolboxItem(true)]
	public sealed class ReferenceHandle: RootHandle
	{
		private void DoSetElement(IElement value)
		{
			if ((InternalElement == null) ||
					(InternalElement != value))
			{
				InternalElement = value;
				ElementChanged();
			}
		}
		/// <summary>
		/// Sets the value of the handle. <paramref name="value"/> must be one of <see cref="IElement"/>, <see cref="IObjectProvider"/> or 
		/// <see cref="IElementProvider"/>.
		/// </summary>
		/// <param name="value">The carrier of the element the handle will reference.</param>
		/// <exception cref="ArgumentException">Thrown if <paramref name="value"/> does not implement IElement, IObjectProvider or IElementProvider.</exception>
		public void SetElement(object value)
		{

			if (value == null)
				DoSetElement(null);
			else
			{
				if (EcoSpace == null)
					throw new InvalidOperationException(HandlesStringRes.sEcoSpaceNotSet);
				if (value is IElement)
					DoSetElement((IElement)value);
				else if (value is IObjectProvider)
					DoSetElement(((IObjectProvider)value).AsIObject());
				else if (value is IElementProvider)
					DoSetElement(((IElementProvider)value).Element);
				else
					throw new ArgumentException("value"); // do not localize
			}
		}
	}
}
